<?PHP
/* Copyright (C) 2001-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2005 Laurent Destailleur  <eldy@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *	\file   	htdocs/fourn/commande/pre.inc.php
 *	\ingroup    compta
 *	\brief  	Fichier gestionnaire du menu commandes fournisseurs
 * 	\version	$Id: pre.inc.php,v 1.16 2009/10/19 19:54:32 eldy Exp $
 */

require("../../main.inc.php");
$langs->load("orders");
$langs->load("suppliers");
$langs->load("companies");

require_once(DOL_DOCUMENT_ROOT."/fourn/fournisseur.class.php");
require_once(DOL_DOCUMENT_ROOT."/fourn/fournisseur.commande.class.php");

function llxHeader($head = "", $title = "", $help_url='', $addons='')
{
	global $user, $langs;
	$langs->load("orders");


	top_menu($head, $title);

	$menu = new Menu();

	if (is_array($addons))
	{
		$menu->add($addons[0][0], $addons[0][1]);
	}
	if ($user->societe_id == 0 && $user->rights->societe->lire)
	{
		$menu->add(DOL_URL_ROOT."/fourn/index.php", $langs->trans("Suppliers"));
		$menu->add_submenu(DOL_URL_ROOT."/fourn/contact.php",$langs->trans("Contacts"));
	}

	$langs->load("bills");
	if ($user->rights->fournisseur->facture->lire)
	{
		$menu->add(DOL_URL_ROOT."/fourn/facture/index.php", $langs->trans("Bills"));
	}
	if ($user->rights->fournisseur->commande->lire)
	{
		$menu->add(DOL_URL_ROOT."/fourn/commande/", $langs->trans("Orders"));
		$menu->add_submenu(DOL_URL_ROOT."/fourn/commande/liste.php", $langs->trans("List"));
	}

	left_menu($menu->liste,$help_url);
}

?>
