-- ===================================================================
-- Copyright (C) 2000-2006 Rodolphe Quiedeville <rodolphe@quiedeville.org>
-- Copyright (C) 2005-2008 Laurent Destailleur  <eldy@users.sourceforge.net>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
--
-- $Id: llx_bank.sql,v 1.1 2009/10/07 18:18:08 eldy Exp $
-- ===================================================================

create table llx_bank
(
  rowid           integer AUTO_INCREMENT PRIMARY KEY,
  datec           datetime,
  datev           date,                      -- date de valeur
  dateo           date,                      -- date operation
  amount          double(24,8) NOT NULL default 0,
  label           varchar(255),
  fk_account      integer,
  fk_user_author  integer,
  fk_user_rappro  integer,
  fk_type         varchar(4),                -- CB, Virement, cheque
  num_releve      varchar(50),
  num_chq         varchar(50),
  rappro          tinyint default 0,
  note            text,
  fk_bordereau    integer DEFAULT 0,
  banque          varchar(255),             -- banque pour les cheques
  emetteur        varchar(255),             -- emetteur du cheque
  author          varchar(40)               -- a supprimer apres migration
)type=innodb;
