<?php
/* Copyright (C) 2003 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2006 Laurent Destailleur  <eldy@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: fiche.php,v 1.2 2006/09/03 13:49:00 eldy Exp $
 * $Source: /cvsroot/dolibarr/dolibarr/htdocs/boutique/critiques/fiche.php,v $
 */

/**
	    \file       htdocs/boutique/critiques/fiche.php
		\ingroup    boutique
		\brief      Page fiche critique OS Commerce
		\version    $Revision: 1.2 $
*/

require("./pre.inc.php");

$id=$_GET["id"];


llxHeader();

if ($id)
{

  $critique = new Critique($dbosc);
  $result = $critique->fetch($id);
  
  if ( $result )
    { 

      print '<div class="titre">Fiche Critique</div><br>';
      
      print '<table border="1" width="100%" cellspacing="0" cellpadding="4">';
      print "<tr>";
      print '<td width="20%">Produit</td><td width="80%">'.$critique->product_name.'</td></tr>';

      print '<tr><td width="20%">Texte</td><td width="80%">'.nl2br($critique->text).'</td></tr>';
      print "</table>";
      


    }
  else
    {
      print "Fetch failed";
    }
  
}

/* ************************************************************************** */
/*                                                                            */ 
/* Barre d'action                                                             */ 
/*                                                                            */ 
/* ************************************************************************** */

print '<br><table width="100%" border="1" cellspacing="0" cellpadding="3">';
print '<td width="20%" align="center">-</td>';
print '<td width="20%" align="center">-</td>';
print '<td width="20%" align="center">-</td>';
print '<td width="20%" align="center">-</td>';
print '<td width="20%" align="center">-</td>';    
print '</table><br>';



$dbosc->close();

llxFooter('$Date: 2006/09/03 13:49:00 $ - $Revision: 1.2 $');

?>
