
/* Copyright (C) 2007-2008 Jrmie Ollivier <jeremie.o@laposte.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// Calcul et affichage en temps rel des informations sur le produit en cours
function modif () {

	var prix_unit = parseFloat ( document.getElementById('frmQte').txtPrixUnit.value );
	var qte = parseFloat ( document.getElementById('frmQte').txtQte.value );
	var _index = parseFloat ( document.getElementById('frmQte').selTva.selectedIndex );
	var tva = parseFloat ( document.getElementById('frmQte').selTva.options[_index].text );
	var remise = parseInt ( document.getElementById('frmQte').txtRemise.value );
	var stock = document.getElementById('frmQte').txtStock.value;

// 		// On s'assure que la quantite tape ne dpasse pas le stock
// 		if ( qte > stock ) {
//
// 			qte = stock;
// 			document.getElementById('frmQte').txtQte.value = qte;
//
// 		}
//
// 		if ( qte < 1 ) {
//
// 			qte = 1;
// 			document.getElementById('frmQte').txtQte.value = qte;
//
// 		}
//
// 		if ( !stock || stock <= 0 ) {
//
// 			qte = 0;
// 			document.getElementById('frmQte').txtQte.value = qte;
//
// 		}

	// Calcul du total HT, sans remise
	var total_ht = Math.round ( (prix_unit * qte) * 100 ) / 100;

	// Calcul du montant de la remise, aprs s'tre assur que cette dernire ne soit pas ngative
	if ( remise <= 0 ) {

		document.getElementById('frmQte').txtRemise.value = 0;
		montant_remise = 0;

	} else {

		var montant_remise = total_ht * remise / 100;

	}

	// Recalcul du montant total, avec la remise
	var total = Math.round ( (total_ht - montant_remise) *100 ) / 100;

	// Affichage du rsultat dans le formulaire
	document.getElementById('frmQte').txtTotal.value = total.toFixed(2);

}

// Affecte la source de la requete (liste droulante ou champ texte 'ref') au champ cach
function setSource (aSrc) {

	document.getElementById('frmFacturation').hdnSource.value = aSrc;
	document.getElementById('frmFacturation').submit();

}

// Vrification de la cohrence des informations saisies dans le formulaire de choix du nombre d'articles
function verifSaisie () {

	if ( document.getElementById('frmQte').txtQte.value ) {

		return true;

	} else {

		document.getElementById('frmQte').txtQte.focus();
		return false;

	}

}

// Vrification de la cohrence des informations saisies dans le formulaire de calcul de la diffrence
function verifDifference () {

	var du = parseFloat ( document.getElementById('frmDifference').txtDu.value );
	var encaisse = parseFloat ( document.getElementById('frmDifference').txtEncaisse.value );

	if ( encaisse > du ) {

		resultat = Math.round ( (encaisse - du) * 100 ) / 100;
		document.getElementById('frmDifference').txtRendu.value = resultat.toFixed(2);

	} else if ( encaisse == du ) {

		document.getElementById('frmDifference').txtRendu.value = '0';

	} else {

		document.getElementById('frmDifference').txtRendu.value = '-';

	}

}

// Affecte le moyen de paiement (ESP, CB ou CHQ) au champ cach en fonction du bouton cliqu
function verifClic (aChoix) {

	document.getElementById('frmDifference').hdnChoix.value = aChoix;

}

// Dtermination du moyen de paiement, et validation du formulaire si les donnes sont cohrentes
function verifReglement () {

	var choix = document.getElementById('frmDifference').hdnChoix.value;
	var du = parseFloat (document.getElementById('frmDifference').txtDu.value);
	var encaisse = parseFloat (document.getElementById('frmDifference').txtEncaisse.value);

	if ( du > 0 ) {

		if ( choix == 'ESP' ) {

			if ( encaisse != 0 && encaisse >= du ) {

				return true;

			} else {

				document.getElementById('frmDifference').txtEncaisse.select();
				document.getElementById('frmDifference').txtEncaisse.focus();
				return false;

			}

		} else if ( choix == 'DIF' ) {

			if ( document.getElementById('frmDifference').txtDatePaiement.value ) {

				return true;

			} else {

				document.getElementById('frmDifference').txtDatePaiement.select();
				document.getElementById('frmDifference').txtDatePaiement.focus();
				return false;

			}

		} else {

			return true;

		}

	} else {

		return false;

	}

}
