<?php 
/*********************************************************************
    install.php

    osTicket Installer.

    Peter Rotich <peter@osticket.com>
    Copyright (c)  2006-2010 osTicket
    http://www.osticket.com

    Released under the GNU General Public License WITHOUT ANY WARRANTY.
    See LICENSE.TXT for details.

    vim: expandtab sw=4 ts=4 sts=4:
    $Id: $
**********************************************************************/

#inits
error_reporting(E_ALL ^ E_NOTICE); //turn on errors
ini_set('magic_quotes_gpc', 0);
ini_set('session.use_trans_sid', 0);
ini_set('session.cache_limiter', 'nocache');
ini_set('display_errors',1); //We want the user to see errors during install process.
ini_set('display_startup_errors',1);

#start session
session_start();
require('setup.inc.php');

$errors=array();
$fp=null;
$_SESSION['abort']=false;
define('VERSION','1.6 ST'); //Current version number
define('VERSION_VERBOSE','1.6 Stable'); //What the user sees during installation process.
define('CONFIGFILE','../include/ost-config.php'); //osTicket config file full path.
define('SCHEMAFILE','./inc/osticket-v1.6.sql'); //osTicket SQL schema.
define('URL',rtrim('http'.(($_SERVER['HTTPS']=='on')?'s':'').'://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']),'setup'));

$install='<strong>&iquest;Nesecita ayuda?</strong> <a href="http://www.osticket.com/support/" target="_blank">Instalaci&oacute;n profesional disponible</a>';
$support='<strong>&iquest;Busca Ayuda?</strong> <a href="http://www.osticket.com/support/" target="_blank">Aqu&iacute; encontraras soporte comercial</a>';

//Basic checks 
$inc='install.inc.php';
$info=$install;

if(file_exists('../ostconfig.php') || file_exists('../include/settings.php')) { //old installation? try upgrading it buddy.
    header('Location: upgrade.php');
    die('Existe una instalaci&oacute;n antigua.... Intenta hacer una actuallizaci&oacute;n');
}elseif((double)phpversion()<4.3){ //Old PHP installation
    $errors['err']='Versi&oacute;n PHP seriamente desactualizada';
    $inc='php.inc.php';
}elseif(!file_exists(CONFIGFILE)) { 
    $errors['err']=sprintf('No se encuentra el archivo de configuraci&oacute;n (%s)',basename(CONFIGFILE));
    $inc='missing.inc.php';
}elseif(($cFile=file_get_contents(CONFIGFILE)) && preg_match("/define\('OSTINSTALLED',TRUE\)\;/i",$cFile)){
    $errors['err']='El archivo de configuraci&oacute;n ya fue modificado';
    $inc='unclean.inc.php';
}elseif(!file_exists(CONFIGFILE) || !is_writable(CONFIGFILE)) { //writable config file??
    clearstatcache();
    $errors['err']='El archivo de configuraci&oacute;n no tiene permisos de escritura';
    $inc='chmod.inc.php';
}else {
    $configfile=file_get_contents(CONFIGFILE); //Get the goodies...peek and tell.
    //Make SURE this is a new installation. 
    if(preg_match("/define\('OSTINSTALLED',TRUE\)\;/i",$configfile) || !strpos($configfile,'%CONFIG-DBHOST')){
        $errors['err']='El archivo de configuraci&oacute;n ya fue modificado';
        $inc='unclean.inc.php';
    }elseif($_POST){
        $f=array();
        $f['title']     = array('type'=>'string', 'required'=>1, 'error'=>'Titulo obligatorio');
        $f['sysemail']  = array('type'=>'email',  'required'=>1, 'error'=>'Email obligatorio');
        $f['username']  = array('type'=>'username', 'required'=>1, 'error'=>'Nombre de usuario obligatorio');
        $f['password']  = array('type'=>'password', 'required'=>1, 'error'=>'Contrase&ntilde;a obligatoria');
        $f['password2'] = array('type'=>'password', 'required'=>1, 'error'=>'Confirma Contrase&ntilde;a');
        $f['email']     = array('type'=>'email',  'required'=>1, 'error'=>'Email valido obligatorio');
        $f['dbhost']    = array('type'=>'string', 'required'=>1, 'error'=>'Nombre de Host obligatorio');
        $f['dbname']    = array('type'=>'string', 'required'=>1, 'error'=>'Nombre Base de Datos obligatorio');
        $f['dbuser']    = array('type'=>'string', 'required'=>1, 'error'=>'Usuario Base de Datos obligatorio');
        $f['dbpass']    = array('type'=>'string', 'required'=>1, 'error'=>'Contrase&ntilde;a Base de Datos obligatoria');
        $f['prefix']    = array('type'=>'string', 'required'=>1, 'error'=>'Prefijo de tabla obligatorio');
        
        $validate = new Validator($f);
        if(!$validate->validate($_POST)){
            $errors=array_merge($errors,$validate->errors());
        }
        if($_POST['sysemail'] && $_POST['email'] && !strcasecmp($_POST['sysemail'],$_POST['email']))
            $errors['email']='Entra en conflicto con el correo electr&oacute;nico del Sistema';
        if(!$errors && strcasecmp($_POST['password'],$_POST['password2']))
            $errors['password2']='La contrase&ntilde;a no coinside';
        //Check table prefix underscore required at the end!
        if($_POST['prefix'] && substr($_POST['prefix'], -1)!='_')
            $errors['prefix']='Prefijo incorrecto. Debe tener gui&oacute;n bajo (_) al final. ej. \'ost_\'';
       
        //Make sure admin username is not very predictable.
        if(!$errors['username'] && in_array(strtolower($_POST['username']),array('admin','admins','username','osticket')))
            $errors['username']='Nombre de usuario incorrecto';

        //Connect to the DB
        if(!$errors && !db_connect($_POST['dbhost'],$_POST['dbuser'],$_POST['dbpass']))
            $errors['mysql']='No se puede conectar al servidor MySQL. Posiblemente la informaci&oacute;n de acceso incorrecta. <br>'; 
        //check mysql version
        if(!$errors && (db_version()<'4.1.1'))
            $errors['mysql']='osTicket requiere MySQL 4.1.1 o mayor. &iexcl;Actualizalo!';
        
        //Select the DB
        if(!$errors && !db_select_database($_POST['dbname'])) {
            //Try creating the missing DB
            if(!mysql_query('CREATE DATABASE '.$_POST['dbname'].' DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci')) {
                $errors['dbname']='Base de Datos no existe.';
                $errors['mysql']='No se a podido crear la Base de Datos.';
            }elseif(!db_select_database($_POST['dbname'])) {
                $errors['dbname']='No se a podido seleccionar la Base de Datos';
            }
        }
        //Get database schema
        if(!$errors && !file_exists(SCHEMAFILE)) {
            $errors['err']='Error interno. Asegurate de que descargaste la &uacute;ltima versi&oacute;n.';
            $errors['mysql']='Falta el archivo de esquema SQL';
        }
        //Open the file for writing..
        if(!$errors && !($fp = @fopen(CONFIGFILE,'r+'))){
            $errors['err']='No se puede abrir el archivo de configuraci&oacute;n para la escritura. Permiso denegado';
        }

        //IF no errors..Do the install. Let the fun start...
        if(!$errors && $fp) {
            define('ADMIN_EMAIL',$_POST['email']); //Needed to report SQL errors during install.
            define('PREFIX',$_POST['prefix']); //Table prefix
            
            $debug=false; //Change it to true to show failed query
            if(!load_sql_schema(SCHEMAFILE,$errors,$debug) && !$errors['err'])
                $errors['err']='Error al analizar el esquema SQL. Busca ayuda de los desarrolladores';

            if(!$errors) {
                $info=$support;

                //Rewrite the config file.
                $configfile= str_replace("define('OSTINSTALLED',FALSE);","define('OSTINSTALLED',TRUE);",$configfile);
                $configfile= str_replace('%ADMIN-EMAIL',$_POST['email'],$configfile);
                $configfile= str_replace('%CONFIG-DBHOST',$_POST['dbhost'],$configfile);
                $configfile= str_replace('%CONFIG-DBNAME',$_POST['dbname'],$configfile);
                $configfile= str_replace('%CONFIG-DBUSER',$_POST['dbuser'],$configfile);
                $configfile= str_replace('%CONFIG-DBPASS',$_POST['dbpass'],$configfile);
                $configfile= str_replace('%CONFIG-PREFIX',$_POST['prefix'],$configfile);
                $configfile= str_replace('%CONFIG-SIRI',Misc::randcode(32),$configfile);

                if(ftruncate($fp,0) && fwrite($fp,$configfile)){
                    //Some more configurations.
                    $tzoffset= date("Z")/3600; //Server's offset.
                    //Create admin user. Dummy last name.
                    $sql='INSERT INTO '.PREFIX.'staff SET created=NOW(), isadmin=1,change_passwd=0,group_id=1,dept_id=1 '.
                        ',email='.db_input($_POST['email']).',firstname='.db_input('Francisco').',lastname='.db_input('Flores').
                        ',username='.db_input($_POST['username']).',passwd='.db_input(MD5($_POST['password'])).
                        ',timezone_offset='.db_input($tzoffset);
                    mysql_query($sql);
                    //Add emails - hopefully the domain is actually valid
                    list($uname,$domain)=explode('@',$_POST['sysemail']);
                    //1 - main support email
                    $sql='INSERT INTO '.PREFIX.'email SET created=NOW(),updated=NOW(),priority_id=2,dept_id=1'.
                         ',name='.db_input('Soporte').',email='.db_input($_POST['sysemail']);
                    mysql_query($sql);
                    //2 - alert email
                    $sql='INSERT INTO '.PREFIX.'email SET created=NOW(),updated=NOW(),priority_id=1,dept_id=1'.
                         ',name='.db_input('Alertas de osTicket').',email='.db_input('alerts@'.$domain);
                    mysql_query($sql);
                    //3 - noreply email
                    $sql='INSERT INTO '.PREFIX.'email SET created=NOW(),updated=NOW(),priority_id=1,dept_id=1'.
                         ',name='.db_input('').',email='.db_input('noreply@'.$domain);
                    mysql_query($sql);
                    //config info 
                    $sql='INSERT INTO '.PREFIX.'config SET updated=NOW() '.
                         ',isonline=0,default_email_id=1,alert_email_id=2,default_dept_id=1,default_template_id=1'.
                         ',timezone_offset='.db_input($tzoffset).
                         ',ostversion='.db_input(VERSION).
                         ',admin_email='.db_input($_POST['email']).
                         ',helpdesk_url='.db_input(URL).
                         ',helpdesk_title='.db_input($_POST['title']);
                    mysql_query($sql);
                    //Create a ticket to make the system warm and happy.
                    $sql='INSERT INTO '.PREFIX.'ticket SET created=NOW(),ticketID='.db_input(Misc::randNumber(6)).
                        ",priority_id=2,dept_id=1,email='support@osticket.com',name='osTicket Support' ".
                        ",subject='osTicket Instalado',helptopic='Soporte Comercial',status='open',source='Web'";
                    if(db_query($sql) && ($id=db_insert_id())){
                        db_query('INSERT INTO '.PREFIX."ticket_message VALUES (1,$id,NULL,".db_input(OSTICKET_INSTALLED).",NULL,'Web','',NOW(),NULL)");
                    }
                    //Log a message.
                    $sql='INSERT INTO '.PREFIX.'syslog SET created=NOW(),updated=NOW() '.
                         ',title="osTicket Instalado",log_type="Debug" '.
                         ',log='.db_input("Felicidades, Instalación básica de OsTicket completada\n\nGacias por elegir OsTicket").
                         ',ip_address='.db_input($_SERVER['REMOTE_ADDR']);
                    mysql_query($sql);
                    $msg='Felicidades, Instalaci&oacute;n b&aacute;sica de OsTicket completada';
                    $inc='done.inc.php';
                }else{
                    $errors['err']='No se puede escribir en el archivo de configuraci&oacute;n';
                }
            }
            @fclose($fp);
        }else{
            
            $errors['err']=$errors['err']?$errors['err']:'Se an producido errores, corrigelos e intantalo de nuevo';
        }
    }
}
$title=sprintf('Versi&oacute;n osTicket  %s - Instalaci&oacute;n Basica',VERSION_VERBOSE);
?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<title>Instalador de osTicket</title>
<link rel="stylesheet" href="style.css" media="screen">
</head>
<body>
<div id="container">
    <div id="header">
        <a id="logo" href="#" title="osTicket"><img src="images/ostlogo.jpg" width="188" height="72" alt="Instalador de osTicket"></a>
        <p id="info"><?php echo $info?></p>
    </div>
    <div id="nav">
        <ul id="sub_nav">
            <li><?php echo $title?></li>
        </ul>
    </div>
    <div class="clear"></div>
    <div id="content" width="100%" height="100%">
       <div>
            <?php if($errors['err']) {?>
                <p align="center" id="errormessage"><?php echo $errors['err']?></p>
            <?php }elseif($msg) {?>
                <p align="center" id="infomessage"><?php echo $msg?></p>
            <?php }elseif($warn) {?>
                <p align="center" id="warnmessage"><?php echo $warn?></p>
            <?php }?>
        </div>
        <div style="padding:0 3px 5px 3px;">
        <?php 
            if(file_exists("./inc/$inc"))
                require("./inc/$inc");
            else
                echo '<span class="error">Ruta de acceso no v&aacute;lida - busca apoyo t&eacute;cnico</span>';
        ?>
        </div>
    </div>
    <div id="footer">Copyright &copy; <?php echo date('Y')?>&nbsp;osTicket.com. &nbsp;Todos los Derechos Reservados.</div>
</div>
</body>
</html>
