<?php 
/*********************************************************************
    setup.inc.php

    Master include file for setup/install scripts.

    Peter Rotich <peter@osticket.com>
    Copyright (c)  2006-2010 osTicket
    http://www.osticket.com

    Released under the GNU General Public License WITHOUT ANY WARRANTY.
    See LICENSE.TXT for details.

    vim: expandtab sw=4 ts=4 sts=4:
    $Id: $
**********************************************************************/
#define paths
define('SETUPINC',true);

if(!defined('INCLUDE_DIR')):
define('ROOT_PATH','../');
define('ROOT_DIR','../');
define('INCLUDE_DIR',ROOT_DIR.'include/');
endif;

#required files
require_once(INCLUDE_DIR.'mysql.php');
require_once(INCLUDE_DIR.'class.validator.php');
require_once(INCLUDE_DIR.'class.format.php');
require_once(INCLUDE_DIR.'class.misc.php');

#Table Prefix: TABLE_PREFIX must be defined by the caller 
function replace_table_prefix($query) {
    return str_replace('%TABLE_PREFIX%',PREFIX, $query);
}


function load_sql_schema($schema,&$errors,$debug=false){

    //Get database schema
    if(!file_exists($schema) || !($schema=file_get_contents($schema))) {
        $errors['err']='Error interno. Asegurate de que descargaste la &uacute;ltima versi&oacute;n.';
        $errors[]='Error al acceder al esquema SQL';
    }else{
        //Loadup SQL schema.
        $queries =array_map('replace_table_prefix',array_filter(array_map('trim',explode(';',$schema)))); //Don't fail me bro!
        if($queries && count($queries)) {
            @mysql_query('SET SESSION SQL_MODE =""');
            foreach($queries as $k=>$sql) {
                if(!mysql_query($sql)){
                    if($debug) echo $sql;
                    //Aborting on error.
                    $errors['err']='Esquema SQL no v&aacute;lido. Busca ayuda de los desarrolladores.';
                    $errors['sql']="[$sql] - ".mysql_error();
                    break;
                }
            }
        }else{
            $errors['err']='Error al analizar el esquema SQL. Busca ayuda de los desarrolladores.';
        }
    }

    return $errors?false:true;
}


#Some messages....

ob_start();
echo "
Gracias por elegir osTicket.

Visita los foros de osTicket http://osticket.com/forums para estar al día sobre las últimas noticias, alertas de seguridad y actualizaciones. Los foros de osTicket por lo tanto es un gran lugar para obtener ayuda, orientación y consejos de otros usuarios. Además de los foros, el wiki de osTicket proporciona una útil colección de materiales educativos, documentación y notas de la comunidad. Damos la bienvenida a tus contribuciones a la comunidad de osTicket.


Si está buscando un mayor nivel de apoyo, prestación de servicios profesionales y apoyo comercial con tiempos de respuesta garantizados, y el acceso al equipo de desarrollo. También podemos ayudar a personalizar osTicket o incluso añadir nuevas características al sistema para satisfacer tus necesidades.

Para obtener más información o para discutir tus necesidades, contactanos en: http://osticket.com/support/ . Tu opinión es muy apreciada!

- El Equipo de OsTicket ";
$msg1 = ob_get_contents();
ob_end_clean();
define('OSTICKET_INSTALLED',trim($msg1));

ob_start();
echo "
osTicket actualizado!

Unete a los foros de osTicket http://osticket.com/forums, si no lo ha hecho ya, para estar al día sobre las últimas noticias, alertas de seguridad y actualizaciones. Tu contribución a la comunidad de osTicket será apreciada!

El equipo de osTicket está comprometido a proporcionar apoyo a todos los usuarios a través de nuestros recursos en línea. Disponemos de una amplia gama de paquetes de soporte comercial y de servicios. Para obtener más información, o para discutir tus necesidades, ponte en contacto con nosotros hoy en http://osticket.com/support/. Cualquier comentario será apreciado

- El Equipo de OsTicket ";
$msg2 = ob_get_contents();
ob_end_clean();
define('OSTICKET_UPGRADED',trim($msg2));

$msg='';
$errors=array();
?>
